/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.item;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.item.ColoredItem;
import com.github.mim1q.convenientdecor.item.material.ModArmorMaterials;
import com.github.mim1q.convenientdecor.network.c2s.SwitchHoodC2SPacket;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RaincoatItem
extends ArmorItem
implements ColoredItem {
    public static final String HOOD_ON_KEY = "tooltip.convenientedecor.raincoat.hood_on";
    public static final String HOOD_OFF_KEY = "tooltip.convenientedecor.raincoat.hood_off";
    public final DyeColor color;

    public RaincoatItem(DyeColor color) {
        super((ArmorMaterial)ModArmorMaterials.RAINCOAT, ArmorItem.Type.CHESTPLATE, (Item.Properties)new FabricItemSettings().maxCount(1));
        this.color = color;
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (clickType == ClickAction.SECONDARY) {
            if (player.m_9236_().f_46443_) {
                player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, 1.0f);
                new SwitchHoodC2SPacket(slot).send();
            }
            return true;
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && slot == EquipmentSlot.FEET.m_20749_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (world.m_46471_() && ConvenientDecor.CONFIG.features.rainclothesIncreasedHp) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 22, 0, false, false, true));
            }
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)(RaincoatItem.isHooded(stack) ? HOOD_OFF_KEY : HOOD_ON_KEY)).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, world, tooltip, context);
    }

    public static void setHooded(ItemStack stack, boolean hooded) {
        stack.m_41784_().m_128379_("hooded", hooded);
    }

    public static boolean isHooded(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("hooded")) {
            return nbt.m_128471_("hooded");
        }
        return false;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }
}

